// Timer Object | Radnen 2008 //

function Timer(style)
{
	if (!this instanceof Timer) return new Timer(style);
	
	this.startTime = 0;
	this.time = 0;
	this.pausedAt = 0;
	this.started = false;
	this.currentTime = 0;
	this.style = style || new Style();
	
	this.onTimeEnd = function(){};
}

Timer.prototype.setTime = function(num) { this.startTime = num, this.currentTime = num; }

Timer.prototype.start = function()
{
	this.time = GetTime();
	this.started = true;
}

Timer.prototype.getTime = function() { return this.currentTime; }

Timer.prototype.drawTime = function(x, y)
{
	if (this.started)
	{
		this.currentTime = this.startTime - Math.floor((GetTime() - this.time)/1000);
		this.style.drawText(x, y, this.currentTime);
		if (this.currentTime == 0) this.started = false, this.onTimeEnd();
	}
	else this.style.drawText(x, y, this.currentTime); 
}

Timer.prototype.pause = function()
{
	this.pausedAt = this.currentTime;
	this.started = false;
}

Timer.prototype.resume = function()
{
	this.time = GetTime();
	this.startTime = this.pausedAt;
	this.started = true;
}

Timer.prototype.addTime = function(num) { this.currentTime += num; }
Timer.prototype.minusTime = function(num) { this.currentTime -= num; }